
$$define	dispcond	^x|optValue('Condition')=0 or optValue('Condition')=''?'':format(' (%s)', optValue('Condition'))|

$$macro selValue(name)
{{
	$$item($(name))
	dupexpected
	editdlg 2
	sformat %0ln
	format "%0ln: ^o'Variable': ^x|listOptions('optTextValue', 'Specialty', ', ')|$(dispcond)"
	cat "Select Value"
	rand -1
	cost 0
	opt
		begin text Condition "" noprint keepold end
		begin text Variable "Variable" keepold noprint end
		begin text Specialty "Specialty 1" keepold noprint end
		begin text Specialty "Specialty 2" keepold noprint end
		end
}}


$$macro grouping(name, format, type, cat, formula, nocond)
{{
	$$item($(name))
	noviolation
	$$ifdef(formula) formula "$(formula)" $$endif
	sformat %0ln%-10r!Grouping
	cat "$$ifdef(cat)$(cat);$$endif$$if(1)Grouping$$endif"
	altformat "Categories" "" "%0ln%-14rc%-7r!"
	format "$$ifdef(format)$(format)$$else%0ln$$endif$$ifnull(nocond)$(dispcond)$$endif%-14rc%-7r!"
	addaslist dupexpected noadj noprereq

	$$ifdef(type)
		$(type)
	$$endif
}}


$$macro spcat(name)
{{
$$macrodesc("Spell category macro for template builder")
$$argdesc(name, "Name of the Category")
	$$scan(name, "^(.+)(\\*)$|^(.+)$", n, vh)
	$$item($(n))
	cat "Spell Category"
	checkexp "spchk(x,c)"
	format "%0ln$$ifdef(vh)*$$endif (any)%-32lt%-12rc%-7rv"
	sformat "%0ln$$ifdef(vh)*$$endif%-5nl"
	varname "$$exp("replaceString(n, \"/[^a-zA-Z]/\", '')")"
	$$ifdef(vh)
		level "iq+magery-3"
		formula vhsp(~x,iq)
		class "VH"
	$$else
		level "iq+magery-2"
		formula hsp(~x,iq)
	$$endif
}}


$$macro incAtt(name, formula)
{{
	$$item($(name))
	varname "$(name)Increase"
	format "%0ln%-14rc%-7r!+^v"
	sformat %0ln+1%-10r!Varies
	cat "Additional Attribute Levels"
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula "attCost($(name)+x)-attCost($(name))"
	$$endif
	checkexp x>0
}}


$$macro decAtt(name, formula)
{{
	$$item($(name))
	varname "$(name)Decrease"
	format "%0ln%-14rc%-7rv"
	sformat %0ln-1%-10r!Varies
	level -1
	cat "Decreased Attribute Levels"
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula "attCost($(name)+x)-attCost($(name))"
	$$endif
	checkexp x<=0
}}


$$macro skillcat(name, diff)
{{
	$$skill	MH $(name)	$(diff)	Skill Category								^n (any)
}}



$$macro itemListDef(name)
{{
	$$grouping($(name), , , Item List Definition)
}}
